package com.amity.socialcloud.sdk.api.social.story

import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.domain.story.markclicked.MarkStoryAsClickedUseCase
import com.amity.socialcloud.sdk.social.domain.story.markseen.MarkStoryAsViewedUseCase

class AmityStoryAnalytics internal constructor(private val story: AmityStory) {

    fun markAsSeen() {
        MarkStoryAsViewedUseCase().execute(story)
    }

    fun markLinkAsClicked() {
        MarkStoryAsClickedUseCase().execute(story)
    }

}