package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.video.data.stream.StreamRepository
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreateStreamUseCase {

    fun execute(
        title: String,
        description: String,
        resolution: AmityBroadcastResolution,
        thumbnailFileId: String? = null,
        metadata: JsonObject? = null,
        isSecure: Boolean? = null,
        channelEnabled: Boolean? = null
    ): Single<AmityStream> {
        return StreamRepository().createStream(
            title = title,
            description = description,
            resolution = resolution,
            thumbnailFileId = thumbnailFileId,
            metadata = metadata,
            isSecure = isSecure,
            channelEnabled = channelEnabled,
        ).flatMap {
            GetStreamUseCase().execute(it).firstOrError()
        }
    }
}