package com.amity.socialcloud.sdk.model.core.notificationtray

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import org.joda.time.DateTime

@Parcelize
data class AmityNotificationTraySeen internal constructor(
    private var uniqueId: String,
    private var lastOccurredAt: DateTime?,
    private var lastSeenAt: DateTime?,
    private var isSeen: Boolean? = null,
) : Parcelable {
    fun getUniqueId(): String {
        return uniqueId
    }

    fun getLastOccurredAt(): DateTime? {
        return lastOccurredAt
    }

    fun getLastSeenAt(): DateTime? {
        return lastSeenAt
    }

    fun isSeen(): Boolean? {
        return isSeen
    }
}
