package com.amity.socialcloud.sdk.chat.data.message.preview

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.MessagePreviewDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelInfoDto
import com.ekoapp.ekosdk.internal.data.model.MessagePreview
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import com.ekoapp.ekosdk.internal.data.model.SubChannelInfo

internal class MessagePreviewEntityMapper : EntityMapper<Pair<MessagePreview, SubChannelInfo>, MessagePreviewEntity>() {

    override fun map(list: List<Pair<MessagePreview,SubChannelInfo>>): List<MessagePreviewEntity> {
        return list.map { map(it) }
    }
    
    fun mapSubChannelInfoToMessagePreview(messagePreviews: List<MessagePreview>, subChannelInfos: List<SubChannelInfo>): List<Pair<MessagePreview,SubChannelInfo>> {
        return messagePreviews.fold(mutableListOf()) { acc, preview ->
            acc.apply {
                subChannelInfos.find { it.subChannelId == preview.subChannelId }?.let { subChannelInfo ->
                    add(Pair(preview, subChannelInfo))
                }
            }
        }
    }

    fun map(data: Pair<MessagePreview,SubChannelInfo>) : MessagePreviewEntity {
        val preview =  MessagePreviewEntity(
            messagePreviewId = data.first.messagePreviewId,
            dataType = data.first.dataType,
            data = data.first.data,
            channelId = data.first.channelId,
            subChannelId = data.first.subChannelId,
            subChannelName = data.second.subChannelName,
            subChannelUpdatedAt = data.second.updatedAt,
            creatorId = data.first.creatorId,
            isDeleted = data.first.isDeleted,
            segment = data.first.segment,
        )
        preview.createdAt = data.first.createdAt
        preview.updatedAt = data.first.updatedAt
        return preview
    }
    
    fun toMesssagePreview(message: EkoMessageDto): MessagePreview {
        return MessagePreview(
            messagePreviewId = message.messageId,
            dataType = message.type,
            data = message.data,
            channelId = message.channelId,
            subChannelId = message.subChannelId,
            creatorId = message.userId,
            isDeleted = message.isDeleted,
            segment = message.segment,
            createdAt = message.createdAt,
            updatedAt = message.updatedAt,
        )
    }
    
    fun toMesssagePreview(message: MessagePreviewDto): MessagePreview {
        return MessagePreview(
                messagePreviewId = message.messagePreviewId,
                dataType = message.dataType,
                data = message.data,
                channelId = message.channelId,
                subChannelId = message.subChannelId,
                creatorId = message.creatorId,
                isDeleted = message.isDeleted,
                segment = message.segment,
                createdAt = message.createdAt,
                updatedAt = message.updatedAt,
        )
    }
    
    fun toSubChannelInfo(subChannel: SubChannelDto): SubChannelInfo? {
        return subChannel.subChannelId?.let { subChannelId ->
            SubChannelInfo(
                subChannelId = subChannelId,
                subChannelName = subChannel.name ?: "",
                updatedAt = subChannel.updatedAt,
            )
        }
    }
    
    fun toSubChannelInfo(subChannel: SubChannelInfoDto): SubChannelInfo {
        return SubChannelInfo(
            subChannelId = subChannel.subChannelId,
            subChannelName = subChannel.subChannelName,
            updatedAt = subChannel.updatedAt,
        )
    }

}