package com.amity.socialcloud.sdk.chat.data.channel

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.ekoapp.ekosdk.internal.EkoChannelEntity


internal class ChannelModelMapper : ModelMapper<EkoChannelEntity, AmityChannel>() {

    override fun map(entity: EkoChannelEntity): AmityChannel {
        return entity.run {
            AmityChannel(
                channelId = channelId,
                defaultSubChannelId = internalChannelId,
                displayName = displayName,
                tags = getTags(),
                metadata = metadata,
                messageCount = messageCount,
                memberCount = memberCount,
                moderatorMemberCount = moderatorMemberCount,
                type = AmityChannel.Type.enumOf(channelType),
                avatarFileId = avatarFileId,
                isRateLimited = isRateLimited,
                isMuted = isMuted,
                isDeleted = isDeleted,
                messagePreviewId = messagePreviewId,
                isPublic = isPublic,
                lastActivity = lastActivity,
                createdAt = createdAt,
                updatedAt = updatedAt,
                path = path,
                attachedTo = AmityChannel.AttachedTo(attachedToPostId, attachedToVideoStreamId),
            )
        }
    }

}