package com.amity.socialcloud.sdk.social.data.category

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime


internal class CategoryLocalDataStore {

    fun saveCategories(categories: List<CommunityCategoryEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().categoryDao().save(categories) }
    }

    fun getCategory(categoryId: String): CommunityCategoryEntity? {
        return UserDatabase.get().categoryDao().getByIdNow(categoryId)
    }

    fun observeCategory(categoryId: String): Flowable<CommunityCategoryEntity> {
        return UserDatabase.get().categoryDao().observeById(categoryId)
    }

    fun getCategories(categoryIds: List<String>): List<CommunityCategoryEntity> {
        var categories = emptyList<CommunityCategoryEntity>()
        Completable.fromCallable {
            val categoryDao = UserDatabase.get().categoryDao()
            val entities = categoryDao.getByIdsNow(categoryIds)
            if(entities.isNotEmpty()) {
                categories = entities
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return categories
    }

    fun getCategoryPagingSource(
        sortOption: AmityCommunityCategorySortOption,
        isDeleted: Boolean?,
    ): PagingSource<Int, CommunityCategoryEntity> {
        return UserDatabase.get().categoryPagingDao().getCategoryPagingSource(
            sortOption = sortOption,
            isDeleted = isDeleted
        )
    }

    fun getLatestCategory(
        isDeleted: Boolean?,
        dynamicQueryStreamKeyCreator: DynamicQueryStreamKeyCreator,
        nonce: Int
    ): Flowable<CommunityCategoryEntity> {
        return UserDatabase.get().categoryDao().getLatestCategory(
            isDeleted,
            dynamicQueryStreamKeyCreator.toMap().hashCode(),
            nonce,
            DateTime.now()
        )
    }

}