package com.ekoapp.ekosdk.internal.mediator

import co.amity.rxremotemediator.PageKeyedRxRemoteMediator
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

abstract class QueryStreamMediator<Entity : Any, ResponseDto : Any>(
    nonce: Int,
    var queryStreamKeyCreator: QueryStreamKeyCreator,
) : PageKeyedRxRemoteMediator<Entity, QueryStreamQueryToken>(
    nonce,
    queryStreamKeyCreator.toMap(),
    UserDatabase.get().queryTokenDao()
) {

    abstract fun getFirstPageRequest(pageSize: Int): Single<ResponseDto>
    abstract fun getFetchByTokenRequest(token: String): Single<ResponseDto>
    abstract fun persistResponse(dto: ResponseDto): Completable
    abstract fun convertResponseToQueryToken(dto: ResponseDto): QueryStreamQueryToken

    override fun forceRefresh(): Boolean {
        return true
    }

    override fun fetchFirstPage(pageSize: Int): Single<QueryStreamQueryToken> {
        return getFirstPageRequest(pageSize)
            .flatMap {
                onFirstPageLoaded(it)
                persistResponse(it)
                    .andThen(Single.just(it))
            }
            .map(::convertResponseToQueryToken)
    }

    override fun fetchByToken(token: String): Single<QueryStreamQueryToken> {
        return getFetchByTokenRequest(token)
            .flatMap { persistResponse(it).andThen(Single.just(it)) }
            .map(::convertResponseToQueryToken)
    }

    open fun onFirstPageLoaded(dto: ResponseDto): Completable {
        return Completable.complete()
    }


}