package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationEvent
import com.ekoapp.ekosdk.internal.api.socket.request.NotifiableEventsRequest


internal class EkoCommunityNotificationEventRequestMapper {
    fun map(events: List<AmityCommunityNotificationEvent.MODIFIER>?): List<NotifiableEventsRequest>? {
        return events?.map { eventItem ->
            NotifiableEventsRequest(
                    name = eventItem.getEventName().value,
                    isPushNotifiable = eventItem.isEnabled(),
                    listenFromRoleIds = eventItem.getIncludedRoles() as List<String>?,
                    ignoreFromRoleIds = eventItem.getExcludedRoles() as List<String>?)
        }
    }

}