package com.amity.socialcloud.sdk.social.data.story

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface StoryPagingDao : DynamicQueryStreamPagingDao<StoryEntity> {

    @RawQuery(observedEntities = [StoryEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, StoryEntity>

    fun getStoriesPagingSource(
        targetType: AmityStory.TargetType,
        targetId: String,
        sortOption: AmityStorySortOption
    ): PagingSource<Int, StoryEntity> {
        val order = if (AmityStorySortOption.LAST_CREATED == sortOption)
            AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC

        val sortColumns = mutableListOf<AmityPagingDao.Sorting>().apply {
            add(
                AmityPagingDao.Sorting.Enum(
                    tableName = "story",
                    columnName = "syncState",
                    enumList = listOf(
                        AmityStory.State.FAILED,
                        AmityStory.State.SYNCING,
                        AmityStory.State.SYNCED).map { it.apiKey },
                )
            )
            add(
                AmityPagingDao.Sorting.Column(
                    tableName = "story",
                    columnName = "createdAt",
                    order = order,
                )
            )
        }
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "story",
                primaryKeyColumnName = "uniqueId",
                dynamicQueryStreamKeyCreator = StoryKeyCreator(
                    targetType = targetType,
                    targetId = targetId,
                    sortOption = sortOption
                ),
                nonce = AmityNonce.ACTIVE_STORIES,
                order =  order,
                sortColumns = sortColumns,
            )
        )
    }
}