package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.ekoapp.ekosdk.internal.api.dto.ChannelMutedDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class ChannelSetMutedUsers : ChannelMutedEventListener() {

    override fun getEventName(): String {
        return "channel.setMutedUsers"
    }

    override fun processEvent(dto: ChannelMutedDto) {
        dto.channelId?.let { channelId ->
            val repository = ChannelMembershipRepository()
            if (dto.muteTimeout?.isAfterNow == true) {
                dto.userIds?.let { userIds ->
                    Completable.concat(
                        userIds.map { userId ->
                            repository
                                .handleMembershipMuted(
                                    channelId = channelId,
                                    userId = userId,
                                    isMuted = true,
                                )
                                .onErrorComplete()
                        }
                    )
                            .subscribeOn(Schedulers.io())
                            .subscribe()
                }
            } else {
                dto.userIds?.let { userIds ->
                    Completable.concat(
                        userIds.map { userId ->
                            repository
                                .handleMembershipMuted(
                                        channelId = channelId,
                                        userId = userId,
                                        isMuted = false,
                                )
                                .onErrorComplete()
                        }
                    )
                        .subscribeOn(Schedulers.io())
                        .subscribe()
                }
            }
        }
    }

}