package com.amity.socialcloud.sdk.social.domain.post.poll

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.model.social.poll.AmityPoll

internal class PollComposerUseCase: ComposerUseCase() {

    fun execute(poll: AmityPoll): AmityPoll {
        addImageToPollAnswer(poll)
        return poll
    }

    private fun addImageToPollAnswer(poll: AmityPoll) {
        poll.answers.forEach { answer ->
            answer.image?.let { image ->
                answer.image = ImageGetUseCase().execute(image.getFileId())
            }
        }
    }
}