package com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTraySeen

class NotificationTraySeenModelMapper :
    ModelMapper<NotificationTraySeenEntity, AmityNotificationTraySeen>() {
    override fun map(entity: NotificationTraySeenEntity): AmityNotificationTraySeen {
        return entity.run {
            AmityNotificationTraySeen(
                uniqueId = userId,
                lastOccurredAt = lastTrayOccurredAt,
                lastSeenAt = lastTraySeenAt,
                isSeen = if (lastTrayOccurredAt == null) true else lastTraySeenAt?.isAfter(lastTrayOccurredAt) == true,
            )
        }
    }
}