package com.amity.socialcloud.sdk.model.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
class AmityRecordingData(private val recordingData: JsonObject? = null) : Parcelable {

    enum class Format {
        MP4, FLV, M3U8;

        val apiString: String
            get() = name.toLowerCase()
    }

    fun getUrl(format: Format): String? {
        return recordingData?.get(format.apiString)?.asJsonObject?.get("url")?.asString
    }
}