package com.amity.socialcloud.sdk.entity.comunity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.joda.time.DateTime

@Entity(tableName = "joinRequest")
open class JoinRequestEntity : EkoObject() {
    @PrimaryKey
    var joinRequestId: String = ""
    var type: String = ""
    var networkId: String = ""
    var targetId: String = ""
    var targetType: String = ""
    var userId: String = ""

    var status: String = ""
    var respondedAt: DateTime? = null

    var createdDate: DateTime? = null
    var updatedDate: DateTime? = null

    var requestorId: String? = null
    var requestorInternalId: String? = null
    var requestorPublicId: String? = null

    var responderId: String? = null
    var responderInternalId: String? = null
    var responderPublicId: String? = null

    override fun getId(): String {
        return joinRequestId
    }

    override fun getCreatedAt(): DateTime? {
        return createdDate
    }

    override fun getUpdatedAt(): DateTime? {
        return updatedDate
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is JoinRequestEntity
                && Objects.equal(joinRequestId, other.joinRequestId)
                && Objects.equal(type, other.type)
                && Objects.equal(networkId, other.networkId)
                && Objects.equal(targetId, other.targetId)
                && Objects.equal(targetType, other.targetType)
                && Objects.equal(userId, other.userId)
                && Objects.equal(status, other.status)
                && Objects.equal(respondedAt, other.respondedAt)
                && Objects.equal(createdDate, other.createdDate)
                && Objects.equal(updatedDate, other.updatedDate)
                && Objects.equal(requestorId, other.requestorId)
                && Objects.equal(requestorInternalId, other.requestorInternalId)
                && Objects.equal(requestorPublicId, other.requestorPublicId)
                && Objects.equal(responderId, other.responderId)
                && Objects.equal(responderInternalId, other.responderInternalId)
                && Objects.equal(responderPublicId, other.responderPublicId)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            joinRequestId,
            type,
            networkId,
            targetId,
            targetType,
            userId,
            status,
            respondedAt,
            createdDate,
            updatedDate,
            requestorId,
            requestorInternalId,
            requestorPublicId,
            responderId,
            responderInternalId,
            responderPublicId
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("joinRequestId", joinRequestId)
            add("type", type)
            add("networkId", networkId)
            add("targetId", targetId)
            add("targetType", targetType)
            add("userId", userId)
            add("status", status)
            add("respondedAt", respondedAt)
            add("createDate", createdDate)
            add("updateDate", updatedDate)
            add("requestorId", requestorId)
            add("requestorInternalId", requestorInternalId)
            add("requestorPublicId", requestorPublicId)
            add("responderId", responderId)
            add("responderInternalId", responderInternalId)
            add("responderPublicId", responderPublicId)
        }
        return super.internalToString(toStringHelper)
    }
}
