package com.ekoapp.ekosdk.internal.usecase.post

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.post.query.AmityFeedSource
import com.amity.socialcloud.sdk.api.social.post.query.AmityUserFeedSortOption
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors


internal class GetUserFeedUseCase {

    fun execute(
        userId: String,
        sortOption: AmityUserFeedSortOption,
        isDeleted: Boolean?,
        matchingOnlyParentPosts: Boolean,
        feedSources: List<String>,
        dataTypes: List<AmityPost.DataType>
    ): Flowable<PagingData<AmityPost>> {
        return PostRepository().getUserFeed(
            userId = userId,
            sortOption = sortOption,
            isDeleted = isDeleted,
            postTypes = dataTypes,
            feedSources = feedSources,
            matchingOnlyParentPosts = matchingOnlyParentPosts
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { post ->
                PostComposerUseCase().execute(post)
            }
        }
    }
}