package com.amity.socialcloud.sdk.social.data.story

import com.amity.socialcloud.sdk.api.social.story.AmityStorySortOption
import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single


internal class StorySinglePageMediator(
    private val targets: List<Pair<AmityStory.TargetType, String>>,
    private val orderBy: AmityStorySortOption
) : SinglePageMediator<StoryEntity, StoryQueryDto>(
    nonce = AmityNonce.STORY_LIST,
    dynamicQueryStreamKeyCreator = StorySinglePageKeyCreator(targets = targets)
) {

    override fun persistResponse(dto: StoryQueryDto): Completable {
        return StoryQueryPersister().persist(dto)
    }

    override fun getRequest(): Single<StoryQueryDto> {
        return StoryRemoteDataStore().getStoriesByTargets(
            targets = targets,
            orderBy = orderBy
        )
    }

    override fun convertResponseToQueryToken(dto: StoryQueryDto): DynamicQueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = null,
            previous = null,
            primaryKeys = getPrimaryKeys(dto)
        )
    }

    private fun getPrimaryKeys(dto: StoryQueryDto): List<String> {
        val primaryKeys = mutableSetOf<String>()
        primaryKeys.addAll(
            dto.stories?.map {
                val storyId = it.storyId ?: "null"
                StoryLocalDataStore().getStoryUniqueId(storyId) ?: storyId
            } ?: emptyList()
        )
        return primaryKeys.toList()
    }

}