package com.amity.socialcloud.sdk.chat.data.channel.membership

import com.amity.socialcloud.sdk.chat.data.channel.ChannelEntityMapper
import com.amity.socialcloud.sdk.chat.data.channel.ChannelLocalDataStore
import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.ChannelMembershipQueryDto
import io.reactivex.rxjava3.core.Completable


internal class ChannelMembershipQueryPersister : QueryPersister<ChannelMembershipQueryDto>() {

    override fun persist(dto: ChannelMembershipQueryDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users)))
            .andThen(ChannelMembershipLocalDataStore().saveChannelMembers(ChannelMembershipEntityMapper().map(dto.channelMembershipDtoList), dto.channelDtoList.map { it.channelId }))
            .andThen(ChannelLocalDataStore().saveChannels(ChannelEntityMapper().map(dto.channelDtoList)))
    }

}