package com.amity.socialcloud.sdk.helper.core.hashtag

import com.google.gson.Gson
import com.google.gson.JsonObject

class AmityHashtagMetadataGetter constructor(private val metadata: JsonObject) {

    fun getHashtags(): List<AmityHashtag> {
        val mentionMetadata = metadata.getAsJsonArray("hashtags")
        return mentionMetadata?.let { jsonArray ->
            jsonArray.map { Gson().fromJson(it, AmityHashtag::class.java) }
        } ?: kotlin.run { listOf() }
    }
}
