package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

class GlobalFeedKeyCreator(private val dataTypes: List<AmityPost.DataType>) : QueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "isDeleted" to false,
            "dataTypes" to PostRepositoryHelper.convertPostTypesToString(dataTypes))
    }

    override fun optionalFilterQuery(): String {
        return getConditionStatement(dataTypes)
    }

    private fun getConditionStatement(
        dataTypes: List<AmityPost.DataType>
    ): String {
        //post is not deleted filter
        val postIsNotDelete = "post.isDeleted = 0"

        //post types filter
        var postTypesFilterStatement = ""
        if (dataTypes.isNotEmpty()) {
            postTypesFilterStatement =
                " and post.postDataType IN (${getPostTypesAsArrayString(dataTypes)})"
        }

        //compose all condition
        return postIsNotDelete +
                postTypesFilterStatement
    }

    fun getPostTypesAsArrayString(dataTypes: List<AmityPost.DataType>): String {
        val typesString = StringBuilder()
        dataTypes.forEachIndexed { index, dataType ->
            if (index == 0) {
                typesString.append("'${dataType.getApiKey()}'")
            } else {
                typesString.append(", '${dataType.getApiKey()}'")
            }
        }
        return typesString.toString()
    }
}