package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.model.core.unread.Unread
import com.ekoapp.ekosdk.internal.ChannelUnreadEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class ChannelUnreadDao : EkoObjectDao<ChannelUnreadEntity>() {
	@Query("SELECT * from channel_unread where channelId = :channelId LIMIT 1")
	abstract fun getById(channelId: String): Flowable<ChannelUnreadEntity>

	@Query("SELECT * from channel_unread where channelId = :channelId LIMIT 1")
	abstract fun getByChannelIdNow(channelId: String): ChannelUnreadEntity?

	@Query("DELETE from channel_unread")
	abstract override fun deleteAll()

	@Query("DELETE from channel_unread where channelId = :channelId")
	abstract fun deleteById(channelId: String)

	@Query("SELECT COALESCE(SUM(channel_unread.unreadCount), 0) as unreadCount, COALESCE(MAX(channel_unread.isMentioned), 0) as isMentioned from channel_unread where channel_unread.channelId in (SELECT channelId from channel)")
	abstract fun getTotalChannelsUnread(): Flowable<Unread>
}