package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.UserSubChannelMarkerEntity
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerDto
import org.joda.time.DateTime

class UserSubChannelMarkerEntityMapper : EntityMapper<UserSubChannelMarkerDto, UserSubChannelMarkerEntity>() {

    override fun map(list: List<UserSubChannelMarkerDto>): List<UserSubChannelMarkerEntity> {
        return list.map { map(it) }
    }

    fun map(dto: UserSubChannelMarkerDto) : UserSubChannelMarkerEntity {
        return UserSubChannelMarkerEntity().apply {
            subChannelId = dto.subChannelId
            channelId = dto.channelId
            userId = dto.userId
            readToSegment = dto.readToSegment
            unreadCount = dto.unreadCount
            deliveredToSegment = dto.deliveredToSegment
            hasMentioned = dto.hasMentioned
            createdAt = dto.createdAt ?: DateTime.now()
            updatedAt = dto.updatedAt ?: DateTime.now()
        }
    }

}