package com.amity.socialcloud.sdk.core.data.notificationtray.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayQueryPersister
import com.amity.socialcloud.sdk.core.data.notificationtray.NotificationTrayRemoteDataStore
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayQueryDto
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTrayItemEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

class NotificationTrayMediator() :
    QueryStreamMediator<NotificationTrayItemEntity, NotificationTrayQueryDto>(
        nonce = AmityNonce.NOTIFICATION_TRAY,
        queryStreamKeyCreator = NotificationTrayKeyCreator()
    ) {

    override fun getFirstPageRequest(pageSize: Int): Single<NotificationTrayQueryDto> {
        return getRequest(limit = pageSize)
    }

    override fun getFetchByTokenRequest(token: String): Single<NotificationTrayQueryDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: NotificationTrayQueryDto): Completable {
        return NotificationTrayQueryPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: NotificationTrayQueryDto): QueryStreamQueryToken {
        return QueryStreamQueryToken(
            queryStreamKeyCreator = NotificationTrayKeyCreator(),
            next = dto.paging?.next,
            previous = dto.paging?.previous,
            primaryKeys = dto.notificationTrayItems?.map { item -> item.id ?: "" } ?: listOf()
        )
    }

    override fun forceRefresh(): Boolean = true

    private fun getRequest(
        limit: Int? = null,
        token: String? = null,
    ): Single<NotificationTrayQueryDto> {
        return NotificationTrayRemoteDataStore().getNotificationTrayItems(
            limit = limit,
            token = token
        ).toRx2()
    }

}