package com.amity.socialcloud.sdk.core.data.session

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class SessionRemoteDataStore {

    fun registerDevice(
        apiKey: String,
        userId: String,
        displayName: String?,
        deviceId: String,
        authToken: String?,
        isLegacyVersion: Boolean
    ): Single<RegisterDeviceDto> {
        return Single.fromCallable {
            RegisterDeviceRequest.create(userId, displayName, deviceId, authToken)
        }.flatMap { request ->
            if (isLegacyVersion) {
                AmityHttpClient.get(SessionApi::class).flatMap {
                    it.registerDeviceLegacy(apiKey, request)
                }

            } else {
                AmityHttpClient.get(SessionApi::class).flatMap {
                    it.registerDevice(apiKey, request)
                }
            }
        }
    }

    fun verifyAccessToken(apiKey: String): Completable {
        return AmityHttpClient.get(SessionApi::class).flatMapCompletable {
            it.verifyAccessToken(apiKey)
        }
    }

    fun revokeAccessToken(): Single<Boolean> {
        return AmityHttpClient.get(SecureSessionApi::class).flatMap {
            it.revokeAccessToken()
        }.map { it.isSuccess }
    }

}