package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.social.poll.AmityPoll
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "poll", primaryKeys = ["pollId"])
class PollEntity : EkoObject() {

    var pollId: String = ObjectId().toHexString()
    var userId: String = ""
    var question: String = ""
    var answers: List<AmityPollAnswer> = emptyList()
    var answerType: String = AmityPoll.AnswerType.SINGLE.value
    var status: String = AmityPoll.Status.CLOSED.value
    var closedAt: DateTime = DateTime.now()
    var isDeleted: Boolean = false
    var isVoted: Boolean = false

    override fun getId(): String {
        return pollId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? PollEntity)?.let { poll ->
            (Objects.equal(pollId, poll.pollId)
                    && Objects.equal(userId, poll.userId)
                    && Objects.equal(question, poll.question)
                    && Objects.equal(answers, poll.answers)
                    && Objects.equal(answerType, poll.answerType)
                    && Objects.equal(status, poll.status)
                    && Objects.equal(closedAt, poll.closedAt)
                    && Objects.equal(isDeleted, poll.isDeleted)
                    && Objects.equal(isVoted, poll.isVoted))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            pollId,
            userId,
            question,
            answers,
            answerType,
            status,
            closedAt,
            isDeleted,
            isVoted
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("pollId", pollId)
            add("userId", userId)
            add("question", question)
            add("answers", answers)
            add("answerType", answerType)
            add("status", status)
            add("closedAt", closedAt)
            add("isDeleted", isDeleted)
            add("isVoted", isVoted)
        }
        return super.internalToString(toStringHelper)
    }
}