package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "channel_role",
		primaryKeys = ["channelId", "userId", "roleName"],
		foreignKeys = [
			ForeignKey(
				entity = ChannelMembershipEntity::class,
				parentColumns = ["channelId", "userId"],
				childColumns = ["channelId", "userId"],
				onDelete = ForeignKey.CASCADE
			)])
data class ChannelMembershipRoleEntity constructor(
	val channelId: String,
	val userId: String,
	val roleName: String
) : EkoRoleObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as ChannelMembershipRoleEntity
		return (Objects.equal(channelId, other.channelId)
				&& Objects.equal(userId, other.userId)
				&& Objects.equal(roleName, other.roleName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				channelId,
				userId,
				roleName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("channelId", channelId)
				.add("userId", userId)
				.add("roleName", roleName)
				.toString()
	}
	
	companion object {
		@JvmStatic
        fun create(channelId: String, userId: String, roleName: String): ChannelMembershipRoleEntity {
			val channelId = EkoPreconditions.checkValidId(channelId, "channelId")
			val userId = EkoPreconditions.checkValidId(userId, "userId")
			val roleName = EkoPreconditions.checkValidId(roleName, "roleName")
			return ChannelMembershipRoleEntity(channelId, userId, roleName)
		}
	}
}