package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.MessageMarkerEntity
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class MessageMarkerDao : EkoObjectDao<MessageMarkerEntity>() {
	@Query("SELECT * from message_marker where messageId = :messageId LIMIT 1")
	abstract fun getById(messageId: String): Flowable<MessageMarkerEntity>
	
	@Query("SELECT * from message_marker where messageId = :messageId LIMIT 1")
	abstract override fun getByIdNow(messageId: String): MessageMarkerEntity?
	
	@Query("Update message_marker set readCount = :readCout where subChannelId = :subChannelId and readCount < :readCout and createdAt <= :createdAt")
	abstract fun updatePreviousMarkersReadCount(subChannelId: String, readCout: Int, createdAt: DateTime)
	
	@Query("Update message_marker set deliveredCount = :deliveredCount where subChannelId = :subChannelId and deliveredCount < :deliveredCount and createdAt <= :createdAt")
	abstract fun updatePreviousMarkersDeliveredCount(subChannelId: String, deliveredCount: Int, createdAt: DateTime)
	
	@Query("DELETE from message_marker")
	abstract override fun deleteAll()
	
	@Query("DELETE from message_marker where messageId = :messageId")
	abstract fun deleteById(messageId: String)
}