package com.amity.socialcloud.sdk.api.chat.channel.create

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.ChannelCreateOption
import com.amity.socialcloud.sdk.chat.domain.channel.CreateChannelUseCase
import com.amity.socialcloud.sdk.chat.domain.channel.CreateConversationWithUserIdsUseCase
import io.reactivex.rxjava3.core.Single

class AmityChannelCreator internal constructor(
    private val channelType: CreationType,
    private val option: ChannelCreateOption
) {

    fun create(): Single<AmityChannel> {
        return when (channelType) {
                CreationType.CONVERSATION -> {
                    createConversation(option)
                }
                else -> {
                    createChannel(channelType, option)
                }
            }
    }

    private fun createChannel(channelType: CreationType,
                              option: ChannelCreateOption
    ): Single<AmityChannel> {
        return  CreateChannelUseCase().execute(channelType, option)
    }

    private fun createConversation(option: ChannelCreateOption): Single<AmityChannel> {
        return CreateConversationWithUserIdsUseCase().execute(option)
    }

    internal enum class CreationType(val apiKey: String) {
        COMMUNITY(AmityChannel.Type.COMMUNITY.apiKey),
        LIVE(AmityChannel.Type.LIVE.apiKey),
        CONVERSATION(AmityChannel.Type.CONVERSATION.apiKey);

        companion object {
            fun enumOf(value: String): CreationType {
                return values().find {
                    it.apiKey == value.toLowerCase()
                } ?: COMMUNITY
            }
        }
    }

}