package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelUnreadInfoEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.domain.marker.channel.SaveChannelMarkerUseCase
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.MarkerSyncDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerDto
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerDto
import io.reactivex.rxjava3.core.Completable

internal class ChannelMarkAsReadPersister : QueryPersister<MarkerSyncDto>() {
    override fun persist(dto: MarkerSyncDto): Completable {
        val subChannelUnreadInfoDto = mutableListOf<Pair<SubChannelMarkerDto, UserSubChannelMarkerDto>>()
        dto.userSubChannelMarkers.map {
            val subChannelMarkerDto = dto.subChannelMarkers.find { subChannelMarker -> subChannelMarker.subChannelId == it.subChannelId }
            if (subChannelMarkerDto != null && !subChannelMarkerDto.isDeleted) {
                subChannelUnreadInfoDto.add(Pair(subChannelMarkerDto, it))
            } else if (subChannelMarkerDto?.isDeleted == true) {
                // Delete unread info of deleted sub channel
                SubChannelMarkerRepository().deleteUnreadInfoBySubChannelId(subChannelMarkerDto.subChannelId)
            } else {
                // Skip this sub channel
            }
        }
        return Completable.fromAction {
            SubChannelMarkerRepository()
                .saveSubChannelUnreadInfo(
                    SubChannelUnreadInfoEntityMapper().map(subChannelUnreadInfoDto)
                )
        }
            .andThen(SaveChannelMarkerUseCase().execute(ChannelMarkerEntityMapper().map(dto.channelMarkers)))
            .andThen(UserMarkerLocalDataStore().saveUserMarkers(UserMarkerEntityMapper().map(dto.userMarkers)))
            .andThen(Completable.fromCallable {
                dto.subChannelMarkers
                    .map { it.channelId }
                    .distinct()
                    .let(ChannelRepository()::notifyChannelsChanges)
            })
    }

}