/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import java.util.UUID;
import org.joda.time.DateTime;

@Entity(tableName="account")
public class EkoAccount {
    @PrimaryKey
    @NonNull
    private String userId;
    private String deviceId;
    private String refreshToken;
    private String accessToken;
    private DateTime issuedAt;
    private DateTime expiresAt;
    private DateTime aboutToExpireAt;

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken2) {
        this.refreshToken = refreshToken2;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public DateTime getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(DateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public DateTime getAboutToExpireAt() {
        return this.aboutToExpireAt;
    }

    public void setAboutToExpireAt(DateTime aboutToExpireAt) {
        this.aboutToExpireAt = aboutToExpireAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userId", (Object)this.userId).add("deviceId", (Object)this.deviceId).add("refreshToken", (Object)this.refreshToken).add("issuedAt", this.issuedAt.getMillis()).add("expiresAt", this.expiresAt.getMillis()).add("aboutToExpireAt", this.aboutToExpireAt.getMillis()).toString();
    }

    public static EkoAccount create(@NonNull String userId) {
        EkoAccount account = new EkoAccount();
        account.setUserId(userId);
        account.setDeviceId(UUID.randomUUID().toString());
        return account;
    }
}

