package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity

internal const val COMMUNITY_FEED_QUERY_TOKEN_TABLE_NAME = "community_feed_query_token"

@Entity(
        tableName = COMMUNITY_FEED_QUERY_TOKEN_TABLE_NAME,
        primaryKeys = ["communityId", "sortBy", "isDeleted", "feedType", "postTypes", "pageNumber"]
)
class CommunityFeedQueryTokenEntity(var communityId: String = "",
                                    var sortBy: String = "",
                                    var feedType: String = "",
                                    var isDeleted: String = "",
                                    var postTypes: String = ""
) : EkoQueryToken() {

}