package com.ekoapp.ekosdk

import android.os.Parcel
import co.amity.rxupload.FileProperties
import com.ekoapp.ekosdk.internal.data.converter.EkoGson
import kotlinx.parcelize.Parceler


object FilePropertiesParceler : Parceler<FileProperties?> {

    override fun create(parcel: Parcel): FileProperties? {
        return parcel.readString()?.let {
            EkoGson.get().fromJson(it, FileProperties::class.java)
        }
    }

    override fun FileProperties?.write(parcel: Parcel, flags: Int) {
        if (this != null) {
            parcel.writeString(EkoGson.get().toJson(this))
        }
    }
}