package com.ekoapp.ekosdk.internal.paging

import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

interface QueryStreamPagingDao<Entity : Any> : AmityPagingDao<Entity> {

    fun generateQueryStreamSQL(
        tableName: String,
        primaryKeyColumnName: String,
        additionalPrimaryKeys: Map<String, Any> = emptyMap(),
        queryStreamKeyCreator: QueryStreamKeyCreator,
        nonce: Int,
        order: AmityPagingDao.Order,
    ): SimpleSQLiteQuery {
        return generateSqlQuery(
            tableName = tableName,
            primaryKeyColumnName = primaryKeyColumnName,
            queryParameters = queryStreamKeyCreator.toMap(),
            nonce = nonce,
            order = order,
            additionalFilter = queryStreamKeyCreator.optionalFilterQuery(),
        )
    }

    @Deprecated("use generateQueryStreamSQL")
    override fun generateSqlQuery(
        tableName: String,
        primaryKeyColumnName: String,
        additionalPrimaryKeys: Map<String, Any>,
        queryParameters: Map<String, Any>,
        nonce: Int,
        order: AmityPagingDao.Order,
        sortColumn: String?,
        additionalFilter: String?
    ): SimpleSQLiteQuery {
        return super.generateSqlQuery(
            tableName,
            primaryKeyColumnName,
            additionalPrimaryKeys,
            queryParameters,
            nonce,
            order,
            sortColumn,
            additionalFilter
        )
    }
}