package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoFollowCountDto
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity

interface EkoFollowCountMapper : EkoObjectMapper<EkoFollowCountDto, EkoFollowCountEntity> {
	companion object {
		val MAPPER: EkoFollowCountMapper = object: EkoFollowCountMapper {
			override fun map(dto: EkoFollowCountDto): EkoFollowCountEntity {
				val followCountEntity = EkoFollowCountEntity()
				if (dto.userId != null) {
					followCountEntity.userId = dto.userId!!
					followCountEntity.followerCount = dto.followerCount
					followCountEntity.followingCount = dto.followingCount
					followCountEntity.pendingCount = dto.pendingCount
				}
				return followCountEntity
			}
		}
	}
}