package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.dto.core.notificationtray.MarkItemSeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.MarkTraySeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayItemSeenRequest
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayQueryDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTraySeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTraySeenRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface NotificationTrayApi {

    @GET("api/v1/notification-tray")
    fun queryNotificationTrayItems(
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query("options[token]", encoded = true) token: String? = null
    ): Single<NotificationTrayQueryDto>

    @GET("api/v1/notification-tray/tray/seen")
    fun getNotificationTraySeen(): Single<NotificationTraySeenDto>

    @POST("api/v1/notification-tray/tray/seen")
    fun markNotificationTrayAsSeen(
        @Body request: NotificationTraySeenRequest
    ): Single<MarkTraySeenDto>

    @POST("api/v1/notification-tray/items/seen")
    fun markNotificationItemsAsSeen(
        @Body request: NotificationTrayItemSeenRequest
    ): Single<MarkItemSeenDto>

}