package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.SocialSettingsEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class SocialSettingsDao : EkoObjectDao<SocialSettingsEntity>() {

    @Query("select * from social_settings where settingId = :settingId")
    abstract fun getSocialSettings(settingId: String): Flowable<SocialSettingsEntity>

    @Query("DELETE from social_settings")
    abstract override fun deleteAll()
}