package com.amity.socialcloud.sdk.model.social.community

enum class AmityCommunityPostSettings (internal val onlyAdminCanPost: Boolean,
									   internal val isPostReviewEnabled: Boolean) {
	ADMIN_CAN_POST_ONLY(true, false),
	ADMIN_REVIEW_POST_REQUIRED(false, true),
	ANYONE_CAN_POST(false, false);
	
	companion object {
		fun enumOf(name: String): AmityCommunityPostSettings {
			return when(name) {
				ADMIN_REVIEW_POST_REQUIRED.name -> ADMIN_REVIEW_POST_REQUIRED
				ADMIN_CAN_POST_ONLY.name -> ADMIN_CAN_POST_ONLY
				else -> ANYONE_CAN_POST
			}
		}
	}

}