package com.amity.socialcloud.sdk.model.core.file

enum class AmityFileAccessType(val apiKey: String) {
    PUBLIC("public"),
    NETWORK("network");

    companion object {
        fun enumOf(apiKey: String): AmityFileAccessType {
            return AmityFileAccessType.values().find { apiKey == it.apiKey } ?: PUBLIC
        }

        const val apiKey: String = "accessType"
    }
}