package com.amity.socialcloud.sdk.core.engine.analytics.capturer

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.ekoapp.ekosdk.internal.entity.AnalyticsEventEntity
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal class AnalyticsEventCapturer {

    private val recentCaptured : HashMap<String, DateTime?> = hashMapOf()

    fun captureEvent(
        event: AnalyticsEventEntity
    ) {
        val deduplicationKey = event.deduplicationKey
        if (recentCaptured[deduplicationKey]?.plusSeconds(5)?.isAfterNow == true) {
            // just recently capture this event, ignore the event.
            return
        }

        // cooldown is off, let's process this event.
        AnalyticsRepository().saveAnalyticEvent(
            event
        )
            .subscribeOn(Schedulers.io())
            .doOnComplete {
                recentCaptured[deduplicationKey] = DateTime.now()
            }
            .doOnError {

            }
            .subscribe()
    }

}