package com.amity.socialcloud.sdk.chat.data.message.flag

import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers


internal class MessageFlagLocalDataStore {

    fun saveFlags(flags: List<EkoMessageFlag>): Completable {
        return Completable.fromAction {
            val dao = UserDatabase.get().messageFlagDao()
            flags.forEach {
                dao.getByIdNow(it.messageId)?.let { flag ->
                    it.localFlag = flag.localFlag
                }
            }
            dao.save(flags)
        }
    }

    fun createFlag(messageId: String)  : Completable {
        return Completable.fromCallable {
            val messageFlag = EkoMessageFlag(messageId)
            UserDatabase.get().messageFlagDao().insert(messageFlag)
        }.subscribeOn(Schedulers.io())
    }

    fun getMessageFlag(messageId: String): EkoMessageFlag? {
        return UserDatabase.get().messageFlagDao().getByMessageId(messageId)
    }

    fun updateMessageFlag(messageFlag: EkoMessageFlag) {
        return UserDatabase.get().messageFlagDao().update(messageFlag)
    }

}