/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.storytarget;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class StoryTargetDao_Impl
extends StoryTargetDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StoryTargetEntity> __insertionAdapterOfStoryTargetEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<StoryTargetEntity> __deletionAdapterOfStoryTargetEntity;
    private final EntityDeletionOrUpdateAdapter<StoryTargetEntity> __updateAdapterOfStoryTargetEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetLocalLastStoryExpiresAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetLastStoryExpiresAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetLocalLastStorySeenExpiresAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateStoryTargetHasUnseen;

    public StoryTargetDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStoryTargetEntity = new EntityInsertionAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `storyTarget` (`uniqueId`,`targetId`,`targetType`,`lastStoryExpiresAt`,`lastStorySeenExpiresAt`,`targetUpdatedAt`,`hasUnseen`,`localSortingDate`,`localLastStoryExpiresAt`,`localLastStorySeenExpiresAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStoryExpiresAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                int _tmp_3 = value.getHasUnseen() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalSortingDate());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStoryExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStorySeenExpiresAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_7);
                }
                String _tmp_8 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_8);
                }
                String _tmp_9 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_9);
                }
            }
        };
        this.__deletionAdapterOfStoryTargetEntity = new EntityDeletionOrUpdateAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `storyTarget` WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfStoryTargetEntity = new EntityDeletionOrUpdateAdapter<StoryTargetEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `storyTarget` SET `uniqueId` = ?,`targetId` = ?,`targetType` = ?,`lastStoryExpiresAt` = ?,`lastStorySeenExpiresAt` = ?,`targetUpdatedAt` = ?,`hasUnseen` = ?,`localSortingDate` = ?,`localLastStoryExpiresAt` = ?,`localLastStorySeenExpiresAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, StoryTargetEntity value) {
                if (value.getUniqueId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUniqueId());
                }
                if (value.getTargetId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTargetId());
                }
                if (value.getTargetType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStoryExpiresAt());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                int _tmp_3 = value.getHasUnseen() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalSortingDate());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStoryExpiresAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLocalLastStorySeenExpiresAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_7);
                }
                String _tmp_8 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_8 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_8);
                }
                String _tmp_9 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_9);
                }
                if (value.getUniqueId() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getUniqueId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from storyTarget";
                return "delete from storyTarget";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetLocalLastStoryExpiresAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?";
                return "update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set lastStoryExpiresAt = ? where targetType = ? and targetId = ?";
                return "update storyTarget set lastStoryExpiresAt = ? where targetType = ? and targetId = ?";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetLocalLastStorySeenExpiresAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?";
                return "update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?";
            }
        };
        this.__preparedStmtOfUpdateStoryTargetHasUnseen = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update storyTarget set localSortingDate = ?, hasUnseen = ? where targetType = ? and targetId = ?";
                return "update storyTarget set localSortingDate = ?, hasUnseen = ? where targetType = ? and targetId = ?";
            }
        };
    }

    @Override
    public void insertImpl(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryTargetEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends StoryTargetEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfStoryTargetEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryTargetEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends StoryTargetEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfStoryTargetEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(StoryTargetEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfStoryTargetEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(StoryTargetEntity object) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends StoryTargetEntity> objects) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(StoryTargetEntity object) {
        this.__db.beginTransaction();
        try {
            StoryTargetDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable updateStoryTargetLocalLastStoryExpiresAt(final String targetType, final String targetId, final DateTime localLastStoryExpiresAt) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLocalLastStoryExpiresAt.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(localLastStoryExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLocalLastStoryExpiresAt.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable updateStoryTargetLastStoryExpiresAt(final String targetType, final String targetId, final DateTime lastStoryExpiresAt) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(lastStoryExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLastStoryExpiresAt.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable updateStoryTargetLocalLastStorySeenExpiresAt(final String targetType, final String targetId, final DateTime localLastStorySeenExpiresAt) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLocalLastStorySeenExpiresAt.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(localLastStorySeenExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetLocalLastStorySeenExpiresAt.release(_stmt);
                }
            }
        });
    }

    @Override
    public Completable updateStoryTargetHasUnseen(final String targetType, final String targetId, final boolean hasUnseen, final DateTime localSortingDate) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetHasUnseen.acquire();
                int _argIndex = 1;
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(localSortingDate);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                int _tmp_1 = hasUnseen ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 3;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetType);
                }
                _argIndex = 4;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, targetId);
                }
                StoryTargetDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    StoryTargetDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    StoryTargetDao_Impl.this.__db.endTransaction();
                    StoryTargetDao_Impl.this.__preparedStmtOfUpdateStoryTargetHasUnseen.release(_stmt);
                }
            }
        });
    }

    @Override
    public Flowable<StoryTargetEntity> observeStory(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where uniqueId = ?", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"storyTarget"}, (Callable)new Callable<StoryTargetEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryTargetEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryTargetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryTargetEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
                    int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
                    int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
                    int _cursorIndexOfHasUnseen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasUnseen");
                    int _cursorIndexOfLocalSortingDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localSortingDate");
                    int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
                    int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryTargetEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                        DateTime _tmpLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                        DateTime _tmpLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                        DateTime _tmpTargetUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfHasUnseen);
                        boolean _tmpHasUnseen = _tmp_3 != 0;
                        _result.setHasUnseen(_tmpHasUnseen);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalSortingDate) ? null : _cursor.getString(_cursorIndexOfLocalSortingDate);
                        DateTime _tmpLocalSortingDate = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setLocalSortingDate(_tmpLocalSortingDate);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                        DateTime _tmpLocalLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                        DateTime _tmpLocalLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryTargetEntity storyTargetEntity = _result;
                    return storyTargetEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryTargetEntity getByIdNowImpl(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where uniqueId = ?", (int)1);
        int _argIndex = 1;
        if (uniqueId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uniqueId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryTargetEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
            int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
            int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
            int _cursorIndexOfHasUnseen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasUnseen");
            int _cursorIndexOfLocalSortingDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localSortingDate");
            int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
            int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryTargetEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfHasUnseen);
                boolean _tmpHasUnseen = _tmp_3 != 0;
                _result.setHasUnseen(_tmpHasUnseen);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalSortingDate) ? null : _cursor.getString(_cursorIndexOfLocalSortingDate);
                DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setLocalSortingDate(_tmpLocalSortingDate);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryTargetEntity storyTargetEntity = _result;
            return storyTargetEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoryTargetEntity getStoryTarget(String targetType, String targetId) {
        String _sql = "select * from storyTarget where targetType = ? and targetId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from storyTarget where targetType = ? and targetId = ?", (int)2);
        int _argIndex = 1;
        if (targetType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetType);
        }
        _argIndex = 2;
        if (targetId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, targetId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            StoryTargetEntity _result;
            int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
            int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
            int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
            int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
            int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
            int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
            int _cursorIndexOfHasUnseen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasUnseen");
            int _cursorIndexOfLocalSortingDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localSortingDate");
            int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
            int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new StoryTargetEntity();
                String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                _result.setUniqueId(_tmpUniqueId);
                String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                _result.setTargetId(_tmpTargetId);
                String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                _result.setTargetType(_tmpTargetType);
                String _tmp = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfHasUnseen);
                boolean _tmpHasUnseen = _tmp_3 != 0;
                _result.setHasUnseen(_tmpHasUnseen);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfLocalSortingDate) ? null : _cursor.getString(_cursorIndexOfLocalSortingDate);
                DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setLocalSortingDate(_tmpLocalSortingDate);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_8 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_9 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            StoryTargetEntity storyTargetEntity = _result;
            return storyTargetEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<StoryTargetEntity> getLatestStoryTargetsImpl(Boolean hasUnseen, int hash, int nonce, DateTime now) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.updatedAt > ? and storyTarget.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by storyTarget.updatedAt desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.updatedAt > ? and storyTarget.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by storyTarget.updatedAt desc limit 1", (int)5);
        int _argIndex = 1;
        Integer n = hasUnseen == null ? null : (_tmp = Integer.valueOf(hasUnseen != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = hasUnseen == null ? null : (_tmp_1 = Integer.valueOf(hasUnseen != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"storyTarget", "amity_paging_id"}, (Callable)new Callable<StoryTargetEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StoryTargetEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)StoryTargetDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    StoryTargetEntity _result;
                    int _cursorIndexOfUniqueId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uniqueId");
                    int _cursorIndexOfTargetId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetId");
                    int _cursorIndexOfTargetType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetType");
                    int _cursorIndexOfLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStoryExpiresAt");
                    int _cursorIndexOfLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastStorySeenExpiresAt");
                    int _cursorIndexOfTargetUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"targetUpdatedAt");
                    int _cursorIndexOfHasUnseen = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hasUnseen");
                    int _cursorIndexOfLocalSortingDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localSortingDate");
                    int _cursorIndexOfLocalLastStoryExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStoryExpiresAt");
                    int _cursorIndexOfLocalLastStorySeenExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localLastStorySeenExpiresAt");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new StoryTargetEntity();
                        String _tmpUniqueId = _cursor.isNull(_cursorIndexOfUniqueId) ? null : _cursor.getString(_cursorIndexOfUniqueId);
                        _result.setUniqueId(_tmpUniqueId);
                        String _tmpTargetId = _cursor.isNull(_cursorIndexOfTargetId) ? null : _cursor.getString(_cursorIndexOfTargetId);
                        _result.setTargetId(_tmpTargetId);
                        String _tmpTargetType = _cursor.isNull(_cursorIndexOfTargetType) ? null : _cursor.getString(_cursorIndexOfTargetType);
                        _result.setTargetType(_tmpTargetType);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStoryExpiresAt);
                        DateTime _tmpLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLastStorySeenExpiresAt);
                        DateTime _tmpLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfTargetUpdatedAt) ? null : _cursor.getString(_cursorIndexOfTargetUpdatedAt);
                        DateTime _tmpTargetUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfHasUnseen);
                        boolean _tmpHasUnseen = _tmp_6 != 0;
                        _result.setHasUnseen(_tmpHasUnseen);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfLocalSortingDate) ? null : _cursor.getString(_cursorIndexOfLocalSortingDate);
                        DateTime _tmpLocalSortingDate = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setLocalSortingDate(_tmpLocalSortingDate);
                        String _tmp_8 = _cursor.isNull(_cursorIndexOfLocalLastStoryExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStoryExpiresAt);
                        DateTime _tmpLocalLastStoryExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                        _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                        String _tmp_9 = _cursor.isNull(_cursorIndexOfLocalLastStorySeenExpiresAt) ? null : _cursor.getString(_cursorIndexOfLocalLastStorySeenExpiresAt);
                        DateTime _tmpLocalLastStorySeenExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                        String _tmp_10 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_11 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_12 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = StoryTargetDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    StoryTargetEntity storyTargetEntity = _result;
                    return storyTargetEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findCacheKeysImpl(Boolean hasUnseen, DateTime expiresAfter) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "select storyTarget.uniqueId from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.localSortingDate > ? and storyTarget.localSortingDate = storyTarget.localLastStoryExpiresAt";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select storyTarget.uniqueId from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.localSortingDate > ? and storyTarget.localSortingDate = storyTarget.localLastStoryExpiresAt", (int)3);
        int _argIndex = 1;
        Integer n = hasUnseen == null ? null : (_tmp = Integer.valueOf(hasUnseen != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = hasUnseen == null ? null : (_tmp_1 = Integer.valueOf(hasUnseen != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(expiresAfter);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

