package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity
import com.ekoapp.ekosdk.internal.keycreator.ReactionKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityReactionPagingDao : DynamicQueryStreamPagingDao<EkoReactionEntity> {

    @RawQuery(observedEntities = [EkoReactionEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoReactionEntity>

    fun getReactionPagingSource(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String?
    ): PagingSource<Int, EkoReactionEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "reaction",
                primaryKeyColumnName = "reactionId",
                dynamicQueryStreamKeyCreator = ReactionKeyCreator(
                    referenceId = referenceId,
                    referenceType = referenceType,
                    reactionName = reactionName
                ),
                nonce = AmityNonce.REACTION_LIST,
                order = AmityPagingDao.Order.DESC,
                sortColumn = "createdAt",
            )
        )
    }
}