package com.ekoapp.ekosdk.internal.data;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.RoomDatabase;

import com.amity.socialcloud.sdk.log.AmityLog;
import com.google.common.base.Preconditions;

abstract class BaseRoomDatabase extends RoomDatabase {

    private static final Callback NO_CALLBACK = new Callback() {};

    static synchronized <T extends BaseRoomDatabase> T init(
            @NonNull Context context,
            @NonNull Class<T> klass,
            @NonNull String name,
            @Nullable T database,
            boolean allowMainThreadQueries,
            @Nullable byte[] passphrase) {
        return init(context, klass, name, database, allowMainThreadQueries,passphrase, NO_CALLBACK);
    }

    static synchronized <T extends BaseRoomDatabase> T init(
            @NonNull Context context,
            @NonNull Class<T> klass,
            @NonNull String name,
            @Nullable T database,
            boolean allowMainThreadQueries,
            @Nullable byte[] passphrase,
            @NonNull Callback callback) {
        Context appContext = context.getApplicationContext();
        if (database != null) {
            database.close();
        }

        Preconditions.checkNotNull(callback, "RoomDatabase.Callback is null");
        final RoomDatabase.Builder<T> builder = RoomUtil.databaseBuilder(appContext, klass, name, passphrase)
                .addCallback(callback);
        //builder.enableMultiInstanceInvalidation();
        builder.setJournalMode(JournalMode.AUTOMATIC);
        if (allowMainThreadQueries) {
            builder.allowMainThreadQueries();
        }
        return builder.build();

//        else {
//            final String TAG = klass.getName();
//            AmityLog.INSTANCE.tag(TAG).e("Database is not null (%s). Called init multiple times?", database);
//            return database;
//        }
    }
}
