package  com.amity.socialcloud.sdk.model.core.follow

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityUserFollowInfo internal constructor(
    private val status: AmityFollowStatus = AmityFollowStatus.NONE,
    private val followingCount: Int = 0,
    private val followerCount: Int = 0
) : Parcelable {

    fun getStatus(): AmityFollowStatus {
        return status
    }

    fun getFollowerCount(): Int {
        return followerCount
    }

    fun getFollowingCount(): Int {
        return followingCount
    }
}
