/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.upload;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import co.amity.rxupload.FileProperties;
import co.amity.rxupload.extension.UriKt;
import com.amity.socialcloud.sdk.core.data.file.RawFileModelMapper;
import com.amity.socialcloud.sdk.infra.upload.AmityUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityVideoUploadService;
import com.amity.socialcloud.sdk.infra.upload.AmityVideoUploadServiceKt;
import com.amity.socialcloud.sdk.model.core.content.AmityContentFeedType;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityRawFile;
import com.amity.socialcloud.sdk.model.core.file.AmityVideo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoFileDao;
import com.ekoapp.ekosdk.internal.util.AppContext;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0017B%\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0016H\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityVideoUploadService;", "Lcom/amity/socialcloud/sdk/infra/upload/AmityUploadService;", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "Lcom/amity/socialcloud/sdk/model/core/file/AmityVideo;", "uri", "Landroid/net/Uri;", "uploadId", "", "feedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "(Landroid/net/Uri;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;)V", "getFeedType", "()Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "getUploadId", "()Ljava/lang/String;", "getUri", "()Landroid/net/Uri;", "getUploadHeaders", "", "", "getUploadParams", "makeUploadServiceRequest", "Lio/reactivex/rxjava3/core/Flowable;", "Builder", "amity-sdk_release"})
public final class AmityVideoUploadService
extends AmityUploadService<AmityUploadResult<? extends AmityVideo>> {
    @NotNull
    private final Uri uri;
    @Nullable
    private final String uploadId;
    @Nullable
    private final AmityContentFeedType feedType;

    private AmityVideoUploadService(Uri uri, String uploadId, AmityContentFeedType feedType) {
        this.uri = uri;
        this.uploadId = uploadId;
        this.feedType = feedType;
    }

    /* synthetic */ AmityVideoUploadService(Uri uri, String string, AmityContentFeedType amityContentFeedType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            amityContentFeedType = null;
        }
        this(uri, string, amityContentFeedType);
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @Nullable
    public final String getUploadId() {
        return this.uploadId;
    }

    @Nullable
    public final AmityContentFeedType getFeedType() {
        return this.feedType;
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadParams() {
        Map params = new LinkedHashMap();
        params.put("accessType", this.getAccessType$amity_sdk_release().getApiKey());
        if (this.feedType != null) {
            params.put(AmityContentFeedType.Companion.getApiKey(), this.feedType.getApiKey());
        }
        return params;
    }

    @Override
    @NotNull
    public Map<String, Object> getUploadHeaders() {
        return MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected Flowable<AmityUploadResult<AmityVideo>> makeUploadServiceRequest() {
        Flowable flowable;
        Long fileSize;
        AssetFileDescriptor fileDescriptor;
        boolean bl;
        ContentResolver contentResolver = AppContext.get().getContentResolver();
        try {
            MediaPlayer mediaPlayer;
            long durationTime = 0L;
            MediaPlayer player = mediaPlayer = MediaPlayer.create((Context)AppContext.get(), (Uri)this.uri);
            boolean bl2 = false;
            durationTime = player.getDuration();
            player.reset();
            player.release();
            bl = durationTime <= AmityVideoUploadServiceKt.access$getMAX_DURATION$p();
        }
        catch (Exception e) {
            bl = true;
        }
        boolean isValidDurationTime = bl;
        AssetFileDescriptor assetFileDescriptor = fileDescriptor = contentResolver.openAssetFileDescriptor(this.uri, "r");
        Long l = fileSize = assetFileDescriptor != null ? Long.valueOf(assetFileDescriptor.getLength()) : null;
        if (fileSize != null && (double)fileSize.longValue() <= 1.0E9) {
            Uri bl2 = this.uri;
            Context context = AppContext.get();
            Map<String, Object> map = this.getUploadParams();
            Map<String, Object> map2 = this.getUploadHeaders();
            String string = this.uploadId;
            String string2 = this.getAccessType$amity_sdk_release().getApiKey();
            Flowable flowable2 = UriKt.upload((Uri)bl2, (Context)context, (String)"api/v4/videos", map2, map, (String)string, (String)"files", (String)string2).flatMap(new Function(this){
                final /* synthetic */ AmityVideoUploadService this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public final Publisher<? extends AmityUploadResult<AmityVideo>> apply(@NotNull FileProperties fileProps) {
                    Flowable flowable;
                    Intrinsics.checkNotNullParameter((Object)fileProps, (String)"fileProps");
                    if (fileProps.getProgress() == 100) {
                        Flowable flowable2 = Single.fromCallable(() -> makeUploadServiceRequest.1.apply$lambda$0(this.this$0, fileProps)).subscribeOn(Schedulers.io()).flatMapPublisher((Function)makeUploadServiceRequest.2.INSTANCE);
                        flowable = flowable2;
                        Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"{\n                      \u2026  }\n                    }");
                    } else {
                        Flowable flowable3 = Flowable.just((Object)new AmityUploadResult.PROGRESS(new AmityUploadInfo(fileProps)));
                        flowable = flowable3;
                        Intrinsics.checkNotNullExpressionValue((Object)flowable3, (String)"{\n                      \u2026)))\n                    }");
                    }
                    return (Publisher)flowable;
                }

                private static final AmityRawFile apply$lambda$0(AmityVideoUploadService this$0, FileProperties $fileProps) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$fileProps, (String)"$fileProps");
                    EkoFileEntity fileEntity = this$0.parseEkoFileEntity($fileProps.getResponseBody());
                    fileEntity.setFilePath($fileProps.getUri().getPath());
                    EkoFileDao fileDao = UserDatabase.get().fileDao();
                    fileDao.insert((EkoObject)fileEntity);
                    return new RawFileModelMapper().map(fileEntity);
                }
            }).onErrorReturn(new Function(this){
                final /* synthetic */ AmityVideoUploadService this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public final AmityUploadResult<AmityVideo> apply(@NotNull Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AmityException exception = this.this$0.parseErrorResponse(it);
                    return new AmityUploadResult.ERROR(exception);
                }
            });
            flowable = flowable2;
            Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"override fun makeUploadS\u2026ception))\n        }\n    }");
        } else {
            AmityException exception = AmityException.Companion.create$default(AmityException.Companion, "File size exceeded!", null, AmityError.FILE_SIZE_EXCEEDED, null, 8, null);
            Flowable flowable3 = Flowable.just((Object)new AmityUploadResult.ERROR(exception));
            flowable = flowable3;
            Intrinsics.checkNotNullExpressionValue((Object)flowable3, (String)"{\n            val except\u2026ROR(exception))\n        }");
        }
        return flowable;
    }

    public /* synthetic */ AmityVideoUploadService(Uri uri, String uploadId, AmityContentFeedType feedType, DefaultConstructorMarker $constructor_marker) {
        this(uri, uploadId, feedType);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amity/socialcloud/sdk/infra/upload/AmityVideoUploadService$Builder;", "", "()V", "feedType", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentFeedType;", "uploadId", "", "uri", "Landroid/net/Uri;", "build", "Lcom/amity/socialcloud/sdk/infra/upload/AmityVideoUploadService;", "feedType$amity_sdk_release", "fileUri", "fileUri$amity_sdk_release", "amity-sdk_release"})
    public static final class Builder {
        private Uri uri;
        @Nullable
        private String uploadId;
        @Nullable
        private AmityContentFeedType feedType;

        @NotNull
        public final Builder fileUri$amity_sdk_release(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            this.uri = uri;
            return this;
        }

        @NotNull
        public final Builder uploadId(@NotNull String uploadId) {
            Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
            this.uploadId = uploadId;
            return this;
        }

        @NotNull
        public final Builder feedType$amity_sdk_release(@NotNull AmityContentFeedType feedType) {
            Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
            this.feedType = feedType;
            return this;
        }

        @NotNull
        public final AmityVideoUploadService build() {
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                uri = null;
            }
            return new AmityVideoUploadService(uri, this.uploadId, this.feedType, null);
        }
    }
}

