package com.amity.socialcloud.sdk.model.core.content

enum class AmityContentFeedType(val apiKey: String) {
	STORY("story"),
	CLIP("clip"),
	MESSAGE("message"),
	POST("post");
	
	companion object {
		fun enumOf(value: String): AmityContentFeedType? {
			return values().find { it.apiKey == value }
		}
		
		val apiKey: String = "feedType"
	}
}