package com.amity.socialcloud.sdk.core.domain.notificationtray.get

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen.NotificationTraySeenRepository
import com.amity.socialcloud.sdk.core.domain.notificationtray.composer.NotificationTraySeenComposerUseCase
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity
import com.amity.socialcloud.sdk.model.core.notificationtray.AmityNotificationTraySeen
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class NotificationTrayLiveObjectUseCase :
    LiveObjectUseCase<NotificationTraySeenEntity, AmityNotificationTraySeen>() {
    override fun createRepository(): AmityObjectRepository<NotificationTraySeenEntity, AmityNotificationTraySeen> {
        return NotificationTraySeenRepository()
    }

    override fun composeModel(model: AmityNotificationTraySeen): AmityNotificationTraySeen? {
        return NotificationTraySeenComposerUseCase().execute(model)
    }

    override fun tombstoneModelType(): TombstoneModelType {
        return TombstoneModelType.NOTIFICATION_TRAY_SEEN
    }
}