package com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

internal class NotificationTraySeenLocalDataStore {
    fun observe(userId: String): Flowable<NotificationTraySeenEntity> {
        return UserDatabase.get().notificationTraySeenDao().observeNotificationTraySeen(userId)
            .map {
                if (it == null) {
                    throw AmityException.create(
                        message = "item not found",
                        cause = null,
                        error = AmityError.ITEM_NOT_FOUND
                    )
                } else {
                    return@map it
                }
            }
    }

    fun getNotificationTraySeen(): NotificationTraySeenEntity? {
        var notificationSeen: NotificationTraySeenEntity? = null
        val userId = AmityCoreClient.getUserId()
        Completable.fromCallable {
            val notiTraySeen = UserDatabase.get().notificationTraySeenDao().getByIdNow(userId)
            if (notiTraySeen != null) {
                notificationSeen = notiTraySeen
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return notificationSeen
    }

    fun saveNotificationTraySeen(notiTraySeen: NotificationTraySeenEntity): Completable {
        return Completable.fromAction {
            UserDatabase.get().notificationTraySeenDao().save(listOf(notiTraySeen))
        }
    }

    fun updateNotificationTraySeen(lastTraySeenAt: DateTime): Completable {
        return Completable.fromAction {
            val userId = AmityCoreClient.getUserId()
            val currentSeen: NotificationTraySeenEntity? = UserDatabase.get().notificationTraySeenDao().getByIdNow(userId)
            if (currentSeen == null || lastTraySeenAt.isAfter(currentSeen.lastTraySeenAt)) {
                UserDatabase.get().notificationTraySeenDao().markAsSeen(userId, lastTraySeenAt)
            }
        }
    }

}