package com.amity.socialcloud.sdk.api.chat.message.create

import android.net.Uri
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment
import com.google.gson.JsonObject

class AmityMessageCreationType(private val subChannelId: String, private val parentId: String?) {
    fun text(text: String): AmityTextMessageCreator.Builder {
        return AmityTextMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .text(text)
    }
    
    fun file(uri: Uri): AmityFileMessageCreator.Builder {
        return file(AmityMessageAttachment.URL(uri))
    }
    
    fun file(attachment: AmityMessageAttachment): AmityFileMessageCreator.Builder {
        return AmityFileMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .attachment(attachment)
    }
    
    fun image(uri: Uri): AmityImageMessageCreator.Builder {
        return image(AmityMessageAttachment.URL(uri))
    }
    
    fun image(attachment: AmityMessageAttachment): AmityImageMessageCreator.Builder {
        return AmityImageMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .attachment(attachment)
    }
    
    fun audio(uri: Uri): AmityAudioMessageCreator.Builder {
        return audio(AmityMessageAttachment.URL(uri))
    }
    
    fun audio(attachment: AmityMessageAttachment): AmityAudioMessageCreator.Builder {
        return AmityAudioMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .attachment(attachment)
    }
    
    fun video(uri: Uri): AmityVideoMessageCreator.Builder {
        return video(AmityMessageAttachment.URL(uri))
    }
    
    fun video(attachment: AmityMessageAttachment): AmityVideoMessageCreator.Builder {
        return AmityVideoMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .attachment(attachment)
    }
    
    fun custom(data: JsonObject): AmityCustomMessageCreator.Builder {
        return AmityCustomMessageCreator.Builder()
                .subChannelId(subChannelId)
                .parentId(parentId)
                .data(data)
    }
}