package com.amity.socialcloud.sdk.model.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
class AmityWatcherData(private val watcherData: JsonObject? = null) : Parcelable {

    enum class Format {
        FLV, HLS, RTMP;

        val apiString: String
            get() = name.toLowerCase()
    }

    fun getUrl(format: Format): String? {
        return watcherData?.get(format.apiString)?.asJsonObject?.get("url")?.asString
    }
}