package com.amity.socialcloud.sdk.api.core.reaction

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.api.core.reaction.query.AmityReactionQuery
import com.amity.socialcloud.sdk.api.core.reaction.reference.AmityReactionReference
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionAddUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionRemoveUseCase
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType
import com.ekoapp.ekosdk.internal.usecase.post.ReactionPagingDataUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class AmityReactionRepository internal constructor() {

    /* begin_public_function
	  id: reaction.query
	  api_style: live_collection
	*/
    fun getReactions(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String? = null,
    ): Flowable<PagingData<AmityReaction>> {
        return ReactionPagingDataUseCase().execute(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        )
    }
    /* end_public_function */

    @Deprecated("Deprecated AmityReactionReference")
    fun getReactions(reactionReference: AmityReactionReference): AmityReactionQuery.Builder {
        return AmityReactionQuery.Builder(reactionReference)
    }

    /* begin_public_function
	  id: reaction.add
	*/
    fun addReaction(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String,
    ): Completable {
        return ReactionAddUseCase().execute(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        )
    }

    /* end_public_function */
    @Deprecated("Deprecated AmityReactionReference")
    fun addReaction(reactionReference: AmityReactionReference, reactionName: String): Completable {
        return ReactionAddUseCase().execute(
            referenceType = reactionReference.referenceType,
            referenceId = reactionReference.referenceId,
            reactionName = reactionName
        )
    }

    /* begin_public_function
	  id: reaction.remove
	*/
    fun removeReaction(
        referenceType: AmityReactionReferenceType,
        referenceId: String,
        reactionName: String,
    ): Completable {
        return ReactionRemoveUseCase().execute(
            referenceType = referenceType,
            referenceId = referenceId,
            reactionName = reactionName
        )
    }
    /* end_public_function */

    @Deprecated("Deprecated AmityReactionReference")
    fun removeReaction(
        reactionReference: AmityReactionReference,
        reactionName: String,
    ): Completable {
        return ReactionRemoveUseCase().execute(
            referenceType = reactionReference.referenceType,
            referenceId = reactionReference.referenceId,
            reactionName = reactionName
        )
    }

}